<?php

namespace Main\Models\Customer;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Customer extends Model 
{

    protected $table = 'customers';
    public $timestamps = false;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('customer_type', 'name', 'nickname', 'email', 'cpf_cnpj', 'rg_ie', 'phone', 'active');
    protected $visible = array('customer_type', 'name', 'nickname', 'cpf_cnpj', 'rg_ie', 'phone', 'active');

    public function address()
    {
        return $this->hasOne('Address', 'customer_id');
    }

    public function deliveryAddresses()
    {
        return $this->hasMany('DeliveryAddress');
    }

}